/*
 * Decompiled with CFR 0.152.
 */
package com.onresolve.scriptrunner.runner.rest.common.settings;

import com.adaptavist.analytic.DuplicateAppAnalyticsSettingsException;
import com.adaptavist.analytic.service.AnalyticService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.onresolve.scriptrunner.analytics.ScriptRunnerAnalyticService;
import com.onresolve.scriptrunner.settings.AnalyticsSettings;
import com.onresolve.scriptrunner.settings.event.AnonymousAnalyticsStatusChangedEvent;
import groovy.json.JsonOutput;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;

@Path(value="/settings/analytics")
@Produces(value={"application/json"})
@SystemAdminOnly
public class AnalyticsEndpoint
implements GroovyObject {
    private final AnalyticService analyticService;
    private final EventPublisher eventPublisher;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Inject
    public AnalyticsEndpoint(ScriptRunnerAnalyticService analyticService, EventPublisher eventPublisher) {
        EventPublisher eventPublisher2;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        ScriptRunnerAnalyticService scriptRunnerAnalyticService = analyticService;
        this.analyticService = scriptRunnerAnalyticService;
        this.eventPublisher = eventPublisher2 = eventPublisher;
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response applySettings(AnalyticsSettings analyticsSettings) {
        if (analyticsSettings.getAtlassianAnalyticsEnabled() != null) {
            return Response.status((int)422).entity((Object)JsonOutput.toJson((Map)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"error", "atlassianAnalyticsEnabled is read-only and must be null"}))).build();
        }
        boolean currentState = this.analyticService.isAdaptavistAnalyticsEnabled();
        if (ScriptBytecodeAdapter.compareNotEqual((Object)analyticsSettings.getAdaptavistAnalyticsEnabled(), (Object)currentState)) {
            Boolean bl = analyticsSettings.getAdaptavistAnalyticsEnabled();
            if (bl == null ? false : bl) {
                this.analyticService.enable();
            } else {
                this.analyticService.disable();
            }
            this.eventPublisher.publish((Object)new AnonymousAnalyticsStatusChangedEvent(Boolean.valueOf(currentState), analyticsSettings.getAdaptavistAnalyticsEnabled()));
        }
        return this.getSettings();
    }

    @GET
    public Response getSettings() {
        return Response.ok((Object)this.getAllAnalyticsSettings(), (String)MediaType.APPLICATION_JSON).build();
    }

    private AnalyticsSettings getAllAnalyticsSettings() {
        boolean adaptavistAnalyticsEnabled = false;
        try {
            adaptavistAnalyticsEnabled = this.analyticService.isAdaptavistAnalyticsEnabled();
        }
        catch (DuplicateAppAnalyticsSettingsException e) {
            adaptavistAnalyticsEnabled = false;
        }
        AnalyticsSettings analyticsSettings = new AnalyticsSettings();
        boolean bl = adaptavistAnalyticsEnabled;
        analyticsSettings.setAdaptavistAnalyticsEnabled(bl);
        boolean bl2 = this.analyticService.isAtlassianAnalyticsEnabled();
        analyticsSettings.setAtlassianAnalyticsEnabled(bl2);
        return analyticsSettings;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AnalyticsEndpoint.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }
}

