/*
 * Decompiled with CFR 0.152.
 */
package com.onresolve.scriptrunner.runner.rest.common.settings;

import com.adaptavist.analytic.metadata.PluginMetadataProvider;
import com.adaptavist.analytic.service.AnalyticService;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.onresolve.scriptrunner.analytics.AnalyticsBackendConfigurationProvider;
import com.onresolve.scriptrunner.analytics.ExampleScriptsAnalyticsConfiguration;
import com.onresolve.scriptrunner.analytics.ScriptRunnerAnalyticService;
import com.onresolve.scriptrunner.analytics.tracking.TrackingUserIdProvider;
import com.onresolve.scriptrunner.runner.PluginInfoProvider;
import groovy.json.JsonBuilder;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;

@Path(value="/sr-analytics")
@Produces(value={"text/html"})
public class Analytics
implements GroovyObject {
    private final AnalyticsBackendConfigurationProvider analyticsBackendConfigurationProvider;
    private final UserManager userManager;
    private final LicenseHandler licenseHandler;
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final ApplicationProperties applicationProperties;
    private final PluginMetadataProvider pluginMetadataProvider;
    private final AnalyticService analyticService;
    private final TrackingUserIdProvider trackingUserIdProvider;
    private final PluginInfoProvider pluginInfoProvider;
    private final ExampleScriptsAnalyticsConfiguration exampleScriptsAnalyticsConfiguration;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Inject
    public Analytics(AnalyticsBackendConfigurationProvider analyticsBackendConfigurationProvider, UserManager userManager, LicenseHandler licenseHandler, SoyTemplateRenderer soyTemplateRenderer, ApplicationProperties applicationProperties, PluginMetadataProvider pluginMetadataProvider, ScriptRunnerAnalyticService analyticService, TrackingUserIdProvider trackingUserIdProvider, PluginInfoProvider pluginInfoProvider, ExampleScriptsAnalyticsConfiguration exampleScriptsAnalyticsConfiguration) {
        ExampleScriptsAnalyticsConfiguration exampleScriptsAnalyticsConfiguration2;
        PluginInfoProvider pluginInfoProvider2;
        PluginMetadataProvider pluginMetadataProvider2;
        ApplicationProperties applicationProperties2;
        SoyTemplateRenderer soyTemplateRenderer2;
        LicenseHandler licenseHandler2;
        UserManager userManager2;
        AnalyticsBackendConfigurationProvider analyticsBackendConfigurationProvider2;
        TrackingUserIdProvider trackingUserIdProvider2;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.trackingUserIdProvider = trackingUserIdProvider2 = trackingUserIdProvider;
        this.analyticsBackendConfigurationProvider = analyticsBackendConfigurationProvider2 = analyticsBackendConfigurationProvider;
        this.userManager = userManager2 = userManager;
        this.licenseHandler = licenseHandler2 = licenseHandler;
        this.soyTemplateRenderer = soyTemplateRenderer2 = soyTemplateRenderer;
        this.applicationProperties = applicationProperties2 = applicationProperties;
        this.pluginMetadataProvider = pluginMetadataProvider2 = pluginMetadataProvider;
        ScriptRunnerAnalyticService scriptRunnerAnalyticService = analyticService;
        this.analyticService = scriptRunnerAnalyticService;
        this.pluginInfoProvider = pluginInfoProvider2 = pluginInfoProvider;
        this.exampleScriptsAnalyticsConfiguration = exampleScriptsAnalyticsConfiguration2 = exampleScriptsAnalyticsConfiguration;
    }

    @GET
    @AnonymousSiteAccess
    public Response get() {
        return this.generateFrameResponse(this.analyticsBackendConfigurationProvider.getKey());
    }

    @GET
    @Path(value="/example-scripts")
    @AnonymousSiteAccess
    public Response getExampleScriptsFrame() {
        return this.generateFrameResponse(this.exampleScriptsAnalyticsConfiguration.getKey());
    }

    public Response generateFrameResponse(String writeKey) {
        if (!this.isAnalyticsEnabled()) {
            return Response.ok((Object)"").build();
        }
        UserKey userKey = this.userManager.getRemoteUserKey();
        boolean isAnonymous = userKey == null;
        return Response.ok((Object)this.render(userKey, isAnonymous, writeKey)).build();
    }

    private String render(UserKey userKey, boolean isAnonymous, String writeKey) {
        String platformId = this.applicationProperties.getPlatformId();
        String pluginInfo = new JsonBuilder((Object)this.pluginMetadataProvider.get()).toString();
        Map data = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"platform", platformId, "pluginInfo", pluginInfo, "productKeys", "[]", "writeKey", writeKey, "userId", this.trackingUserIdProvider.getUserIdForUserKey(userKey), "isAnonymous", isAnonymous});
        if (ScriptBytecodeAdapter.compareEqual((Object)platformId, (Object)"jira")) {
            String productKeys = new JsonBuilder((Object)this.licenseHandler.getProductKeys()).toString();
            data.put("productKeys", productKeys);
        }
        return this.soyTemplateRenderer.render(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.pluginInfoProvider.getPluginKey()}, new String[]{"", ":analytics"})), "plugin.com.onresolve.scriptrunner.analytics", data);
    }

    private boolean isAnalyticsEnabled() {
        return this.analyticService.isAtlassianAnalyticsEnabled() && this.analyticService.isAdaptavistAnalyticsEnabled();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != Analytics.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }
}

