/*
 * Decompiled with CFR 0.152.
 */
package com.onresolve.licensing;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.extras.api.LicenseType;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.upm.api.license.PluginLicenseEventRegistry;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.license.event.PluginLicenseChangeEvent;
import com.atlassian.upm.api.license.event.PluginLicenseExpiredEvent;
import com.atlassian.upm.api.license.event.PluginLicenseRemovedEvent;
import com.atlassian.upm.api.util.Option;
import com.onresolve.licensing.LicenceChecker;
import com.onresolve.licensing.LicenceCheckerJob;
import com.onresolve.licensing.SrLicenceChangedEvent;
import com.onresolve.licensing.SrLicenseChangedCause;
import com.onresolve.scriptrunner.runner.FullSystemStartedInitialiser;
import com.onresolve.scriptrunner.runner.PluginInfoProvider;
import java.lang.management.ManagementFactory;
import java.util.Iterator;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLicenceChecker
extends FullSystemStartedInitialiser
implements LifecycleAware,
LicenceChecker {
    private static final Logger log = LoggerFactory.getLogger(AbstractLicenceChecker.class);
    private final PluginLicenseManager pluginLicenseManager;
    private final PluginLicenseEventRegistry pluginLicenseEventRegistry;
    private final SchedulerService schedulerService;
    private final String pluginKey;
    private final boolean requiresLicense;
    public static String MESSAGE_CHANNEL_NAME = "SR_LICENCE_DETECTED";
    private static final JobRunnerKey LICENCE_CHECK_JOB_RUNNER_KEY = JobRunnerKey.of((String)"com.onresolve.scriptrunner:LicenseCheckJob");
    private static final String LICENCE_CHECK_CRON = "0 0 0 ? * *";
    private volatile Boolean isLicensed = null;

    public AbstractLicenceChecker(PluginLicenseManager pluginLicenseManager, PluginLicenseEventRegistry pluginLicenseEventRegistry, EventPublisher eventPublisher, PluginInfoProvider pluginInfoProvider, SchedulerService schedulerService) {
        super(eventPublisher, pluginInfoProvider);
        this.pluginLicenseManager = pluginLicenseManager;
        this.pluginLicenseEventRegistry = pluginLicenseEventRegistry;
        this.pluginKey = pluginLicenseManager.getPluginKey();
        this.schedulerService = schedulerService;
        this.requiresLicense = this.doesProductRequireLicensing();
    }

    public void onFullSystemStart() {
        JobId jobId = JobId.of((String)(this.pluginKey + ":isLicensedJob"));
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)LICENCE_CHECK_JOB_RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.forCronExpression((String)LICENCE_CHECK_CRON));
        this.isLicensed();
        try {
            this.schedulerService.scheduleJob(jobId, jobConfig);
        }
        catch (SchedulerServiceException e) {
            log.error("Problem scheduling license checker job", (Throwable)e);
        }
    }

    public void handleEvent(PluginLicenseChangeEvent event) {
        this.handleLicense((Option<PluginLicense>)Option.some((Object)event.getLicense()), SrLicenseChangedCause.EVENT);
    }

    public void handleEvent(PluginLicenseExpiredEvent event) {
        this.handleLicense((Option<PluginLicense>)Option.some((Object)event.getLicense()), SrLicenseChangedCause.EVENT);
    }

    public void handleEvent(PluginLicenseRemovedEvent event) {
        this.handleLicense((Option<PluginLicense>)Option.none(PluginLicense.class), SrLicenseChangedCause.EVENT);
    }

    protected abstract boolean isDevInstance();

    protected static Boolean isDebug() {
        String inputArgs = ManagementFactory.getRuntimeMXBean().getInputArguments().toString();
        return inputArgs.indexOf("-agentlib:jdwp") > 0 || inputArgs.indexOf("-Xdebug") > 0;
    }

    protected boolean isDevLicence(LicenseType licenseType) {
        return licenseType == LicenseType.DEVELOPER || licenseType == LicenseType.COMMUNITY || licenseType == LicenseType.TESTING;
    }

    private boolean doesProductRequireLicensing() {
        return !this.isDevInstance();
    }

    public void updateLicenseState(SrLicenseChangedCause cause) {
        try {
            this.handleLicense((Option<PluginLicense>)this.pluginLicenseManager.getLicense(), cause);
        }
        catch (Exception e) {
            log.warn("Problem getting licence - this is expected if you have group synchronisation from LDAP set up: " + e.getMessage());
        }
    }

    private void handleLicense(Option<PluginLicense> maybeLicense, SrLicenseChangedCause cause) {
        boolean licensedState;
        boolean bl = licensedState = this.isLicensed(maybeLicense) || !this.requiresLicense;
        if (this.isLicensed == null || this.isLicensed != licensedState) {
            this.isLicensed = licensedState;
            this.eventPublisher.publish((Object)new SrLicenceChangedEvent(this.isLicensed.booleanValue(), cause));
        }
    }

    public boolean isLicensed() {
        if (this.isLicensed == null) {
            this.updateLicenseState(SrLicenseChangedCause.STARTUP);
        }
        return this.isLicensed;
    }

    private boolean isLicensed(Option<PluginLicense> maybeLicense) {
        Iterator iterator = maybeLicense.iterator();
        if (iterator.hasNext()) {
            PluginLicense license = (PluginLicense)iterator.next();
            if (!license.isValid()) {
                log.warn("Invalid license for plugin \"" + this.pluginKey + "\" (" + license.getError().getOrElse((Object)null) + ")");
                return false;
            }
            log.info("Validated license for plugin '" + this.pluginKey + "'");
            return true;
        }
        log.warn("No license available for plugin '" + this.pluginKey + "'");
        return false;
    }

    public void onStart() {
        super.onStart();
        this.schedulerService.registerJobRunner(LICENCE_CHECK_JOB_RUNNER_KEY, (JobRunner)new LicenceCheckerJob(this));
        this.pluginLicenseEventRegistry.register((Object)this);
    }

    @PreDestroy
    public void preDestroy() {
        this.schedulerService.unregisterJobRunner(LICENCE_CHECK_JOB_RUNNER_KEY);
        this.pluginLicenseEventRegistry.unregister((Object)this);
    }
}

