/*
 * Decompiled with CFR 0.152.
 */
package com.onresolve.scriptrunner.runner.rest.common.settings;

import com.adaptavist.analytic.DuplicateAppAnalyticsSettingsException;
import com.adaptavist.analytic.service.AnalyticService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugins.rest.common.security.jersey.SysadminOnlyResourceFilter;
import com.onresolve.scriptrunner.analytics.ScriptRunnerAnalyticService;
import com.onresolve.scriptrunner.settings.AnalyticsSettings;
import com.onresolve.scriptrunner.settings.event.AnonymousAnalyticsStatusChangedEvent;
import com.sun.jersey.spi.container.ResourceFilters;
import groovy.json.JsonOutput;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;

@Path(value="/settings/analytics")
@Produces(value={"application/json"})
@ResourceFilters(value={SysadminOnlyResourceFilter.class})
public class AnalyticsEndpoint
implements GroovyObject {
    private final AnalyticService analyticService;
    private final EventPublisher eventPublisher;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Inject
    public AnalyticsEndpoint(ScriptRunnerAnalyticService analyticService, EventPublisher eventPublisher) {
        EventPublisher eventPublisher2;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        ScriptRunnerAnalyticService scriptRunnerAnalyticService = analyticService;
        this.analyticService = scriptRunnerAnalyticService;
        this.eventPublisher = eventPublisher2 = eventPublisher;
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response applySettings(AnalyticsSettings analyticsSettings) {
        if (analyticsSettings.atlassianAnalyticsEnabled != null) {
            return Response.status((int)422).entity((Object)JsonOutput.toJson((Map)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"error", "atlassianAnalyticsEnabled is read-only and must be null"}))).build();
        }
        boolean currentState = this.analyticService.isAdaptavistAnalyticsEnabled();
        if (ScriptBytecodeAdapter.compareNotEqual((Object)analyticsSettings.adaptavistAnalyticsEnabled, (Object)currentState)) {
            Boolean bl = analyticsSettings.adaptavistAnalyticsEnabled;
            if (bl == null ? false : bl) {
                this.analyticService.enable();
            } else {
                this.analyticService.disable();
            }
            this.eventPublisher.publish((Object)new AnonymousAnalyticsStatusChangedEvent(Boolean.valueOf(currentState), analyticsSettings.adaptavistAnalyticsEnabled));
        }
        return this.getSettings();
    }

    @GET
    public Response getSettings() {
        return Response.ok((Object)this.getAllAnalyticsSettings(), (String)MediaType.APPLICATION_JSON).build();
    }

    private AnalyticsSettings getAllAnalyticsSettings() {
        boolean adaptavistAnalyticsEnabled = false;
        try {
            boolean bl = this.analyticService.isAdaptavistAnalyticsEnabled();
            adaptavistAnalyticsEnabled = bl;
        }
        catch (DuplicateAppAnalyticsSettingsException e) {
            boolean bl;
            adaptavistAnalyticsEnabled = bl = false;
        }
        AnalyticsSettings analyticsSettings = new AnalyticsSettings();
        boolean bl = adaptavistAnalyticsEnabled;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)bl, AnalyticsEndpoint.class, (GroovyObject)analyticsSettings, (String)"adaptavistAnalyticsEnabled");
        boolean bl2 = this.analyticService.isAtlassianAnalyticsEnabled();
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)bl2, AnalyticsEndpoint.class, (GroovyObject)analyticsSettings, (String)"atlassianAnalyticsEnabled");
        return analyticsSettings;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AnalyticsEndpoint.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }
}

